%%% Ugly hack to trace the backtrack tree of a CSP in Prolog
%%% Copyright David Poole, 2008
go :-
   set(0,'A',A),set(1,'B',B), ch((A<B)),
   set(2,'C',C),ch((abs(A-C)=:=1,abs(B-C) mod 2 =:= 0)),
   set(3,'D',D),ch((B =\= D,D>A,D =\= C)),
   set(4,'E',E),ch((E =\= C, E<D-1, E=\=B-2)),
   set(5,'F',F),ch((A =\= F, B =\= F, C =\= F, D =\= F, abs(E-F) mod 2 =:= 1)),
   writeline(['success']),
   fail.

% Possible values
val(1).
val(2).
val(3).
val(4).

% ch(C) checks whether constraint C is satisfied.
ch(C) :-
    C,!.
ch(_) :- writeline( ['failure']),
	fail.

% set(Num,Name,V) sets variable Name to have value V where Num is the
%   number of the variable to be assigned (affects the padding).
set(Num,Name,V) :-
   val(V),
   write_set(Num,Name,V).

write_set(_,Name,1) :- !,
   writel([Name,'=',1,' ']).
write_set(Num,Name,V) :-
   write_times(Num,'    '),
   writel([Name,'=',V,' ']).

write_times(0,_) :- !.
write_times(N,S) :-
	write(S),
	N1 is N-1,
	write_times(N1,S).

writel([]).
writel([H|T]) :-
	write(H),
	writel(T).

writeline(L) :- writel(L),nl.
